
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Nov 29 18:42:53 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_menu.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */
/*lint --e(553) */
/*lint --e(713) */
/***** Include Files **************/


#include "CRYS.h"
#include "MW_ATP_UTIL_funcs.h"
#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_ATP_TST_main.h"
#include "CRYS_SELF_TEST.h"
#include "DX_VOS_Mem.h"
#include "DX_VOS_File.h"
#include "DX_VOS_Stdio.h"

#ifdef CRYS_SEP_IN_HALT_MODE
extern void GEN_AcquireCCLock(void);
#endif

/******** Defines ************/
#if TST_ENABLE_PERFORMANCE_TST
DxUint32_t      TST_Timer = 1;
DxUint32_t      TST_PerformanceDataSize;
float           TST_PerformanceMasure;
#endif
/*AES*/
#if TST_USE_AES_DATA
extern CRYSError_t CRYS_ATP_TST_AES_Acceptance_ALL_TESTS(void);
#endif
/*DES*/
#if TST_USE_DES_DATA
extern CRYSError_t CRYS_ATP_TST_DES_Acceptance_ALL_TESTS(void);
#endif
/*HASH*/
#if TST_USE_HASH_DATA
extern CRYSError_t CRYS_ATP_TST_HASH_Acceptance_ALL_TESTS(void);
#endif
/*HMAC*/
#if TST_USE_HMAC_DATA
extern CRYSError_t CRYS_ATP_TST_HMAC_Acceptance_ALL_TESTS(void);
#endif
/*RSA*/
#if TST_USE_RSA_DATA
extern CRYSError_t CRYS_ATP_TST_RSA_Acceptance_ALL_TESTS(int TST_KeyGeneration_TestStatus);
#endif
/*DH*/
#if TST_USE_DH_DATA
extern CRYSError_t CRYS_ATP_TST_DH_Acceptance_ALL_TESTS(void);
#endif
/*RND*/
#if TST_USE_RND_DATA
extern CRYSError_t CRYS_ATP_TST_RND_Acceptance_ALL_TESTS(void);
#endif
/*RC4*/
#if TST_USE_RC4_DATA
extern CRYSError_t CRYS_ATP_TST_RC4_Acceptance_ALL_TESTS(void);
#endif
/*C2*/
extern CRYSError_t CRYS_ATP_TST_C2_Acceptance_ALL_TESTS(void);
/*ECC*/
#if TST_USE_ECC_DATA
extern CRYSError_t CRYS_ATP_TST_ECC_Acceptance_ALL_TESTS(int TST_KeyGeneration_TestStatus);
#endif

#if TST_USE_FLOW_DATA
#ifndef CRYS_NO_FLOW_SUPPORT
extern CRYSError_t CRYS_ATP_TST_FLOW_Acceptance_ALL_TESTS(void);
#endif
#endif

#ifndef CRYS_NO_OTF_MC_SUPPORT
extern CRYSError_t CRYS_ATP_OTF_MC_Acceptance_ALL_TESTS(void);
#endif

/******** Enums ************/
/******** Typedefs ***********/
/******** Global Data **********/
CRYS_Version_t  TST_ATP_CRYS_version;

/******** Public Functions *****/

/***************************
 * Function Name:
 *  CRYS_ATP_TST_RunAllAcceptance_tests
 *
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * This function runs all of the Acceptance tests
 *
 **************************/
DxError_t CRYS_ATP_TST_RunAllAcceptance_tests(DxUint32_t TST_KeyGeneration_TestStatus)
{
    CRYSError_t TST_Status = TESTPASS ,TST_TestStatus = TESTPASS;

#ifndef CRYS_NO_AES_SUPPORT
#if TST_USE_AES_DATA
    /*AES*/
    TST_TestStatus = CRYS_ATP_TST_AES_Acceptance_ALL_TESTS();
    TST_Status = TST_Status+TST_TestStatus;
#endif
#endif
#ifndef CRYS_NO_DES_SUPPORT
#if TST_USE_DES_DATA
    /*DES*/
    TST_TestStatus = CRYS_ATP_TST_DES_Acceptance_ALL_TESTS();
    TST_Status = TST_Status+TST_TestStatus;
#endif
#endif
#ifndef CRYS_NO_HASH_SUPPORT
    /*HASH*/
    #if TST_USE_HASH_DATA
    TST_TestStatus = CRYS_ATP_TST_HASH_Acceptance_ALL_TESTS();
    TST_Status = TST_Status+TST_TestStatus;
    #endif
    /*HMAC*/
    #if TST_USE_HMAC_DATA
    TST_TestStatus = CRYS_ATP_TST_HMAC_Acceptance_ALL_TESTS();
    TST_Status = TST_Status+TST_TestStatus;
    #endif
    #ifndef CRYS_NO_PKI_SUPPORT
    /*RSA*/
    #if TST_USE_RSA_DATA
    TST_TestStatus = CRYS_ATP_TST_RSA_Acceptance_ALL_TESTS(TST_KeyGeneration_TestStatus);
    TST_Status = TST_Status+TST_TestStatus;
    #endif
    /*DH*/
    #if TST_USE_DH_DATA
    TST_TestStatus = CRYS_ATP_TST_DH_Acceptance_ALL_TESTS();
    TST_Status = TST_Status+TST_TestStatus;
    #endif
    #endif
    /*RNG*/
    #if TST_USE_RND_DATA
    TST_TestStatus = CRYS_ATP_TST_RND_Acceptance_ALL_TESTS();
    TST_Status = TST_Status+TST_TestStatus;
    #endif
#endif
#ifndef CRYS_NO_RC4_SUPPORT
    /*RC4*/
    #if TST_USE_RC4_DATA
    TST_TestStatus = CRYS_ATP_TST_RC4_Acceptance_ALL_TESTS();
    TST_Status = TST_Status+TST_TestStatus;
    #endif
#endif
#ifndef CRYS_NO_ECPKI_SUPPORT
#if TST_USE_ECC_DATA
    /*ECC*/
    TST_TestStatus = CRYS_ATP_TST_ECC_Acceptance_ALL_TESTS(TST_KeyGeneration_TestStatus);
    TST_Status = TST_Status+TST_TestStatus;
#endif
#endif
	#ifndef CRYS_NO_C2_SUPPORT
    /*C2*/
    TST_TestStatus = CRYS_ATP_TST_C2_Acceptance_ALL_TESTS();
    TST_Status = TST_Status+TST_TestStatus;
#endif
    #ifndef CRYS_NO_FLOW_SUPPORT
    #if TST_USE_FLOW_DATA    
    TST_TestStatus = CRYS_ATP_TST_FLOW_Acceptance_ALL_TESTS();
    TST_Status = TST_Status+TST_TestStatus;
    #endif
    #endif

    
    #ifndef CRYS_NO_OTF_MC_SUPPORT
    TST_TestStatus = CRYS_ATP_OTF_MC_Acceptance_ALL_TESTS();
    TST_Status = TST_Status+TST_TestStatus;
    #endif

    /*Check if all tests pass*/
    if (TST_Status != TESTPASS)
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE ATP TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
        }
        else
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"* ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP ***\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE ATP  TESTS PASS     :-)         *****\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"* ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP  ATP ***\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
        }
    return TST_Status;
}

/***************************
 * Function Name:
 *  CRYS_ATP_menu
 *
 * Inputs:
 * 	none
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * This function displays and dispatches CRYS ATP tests
 *
 **************************/
DxError_t CRYS_ATP_menu(void)
 {
    DxUint16_t          TST_EnginesSelect;
    DxUint16_t          TST_EnginesTestResult=0;
    CRYS_SelfTestData_t TST_SelfTestData;
    CRYSError_t         TST_TestStatus = TESTPASS;
    
    #ifdef CRYS_SEP_IN_HALT_MODE
    /* set BUSY to host */
    GEN_AcquireCCLock();
    #endif
    
    
    /* Get CRYS Version */
    CRYS_GetVersion(&TST_ATP_CRYS_version);

    /* Preform Self tests before running the Acceptance*/
    /******************/
    TST_EnginesSelect = CRYS_SELF_TEST_ALL_BIT;
    TST_EnginesSelect = TST_EnginesSelect;


    TST_TestStatus = CRYS_SelfTest(TST_EnginesSelect,
                                  &TST_EnginesTestResult,
                                  &TST_SelfTestData);

    TST_TestStatus = TST_ATP_CheckErrorReturn(TST_TestStatus,
                                             "CRYS_SelfTest",
                                             "!!!!!!!!!",
                                             "!!!!!!!!!");
    if (TST_TestStatus != TESTPASS)
        return (CRYSError_t)TESTFAIL;
   

    /* Check that all engines pass */
    /***********/
    if (TST_EnginesTestResult != TESTPASS)
    {
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"ERROR MASSAGE!! - One Of the Engines Failed On Self Test\n"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"ERROR MASSAGE!! %x - Error Word \n",TST_EnginesTestResult));
    }
    else
    {
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"TST_message - ALL Engines PASS self Tests\n"));
    }


    if (TST_IsInteractive == 1)
    {
       CRYS_ATP_TST_RunAllAcceptance_tests(TST_UseInternalKG);
    }
    else
    {
        DxUint8_t  Var;

        do
        {
	        do
	        {
			        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n           -- DISCRETIX LTD 2007 --              "));
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n       -- Acceptance tests Ver -  06.03.00 --        "));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------"));
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n---[ Main Tests Menu ]-------------------------------"));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------"));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [0] - Get CRYS Version                              "));
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------"));
                    #ifndef CRYS_NO_AES_SUPPORT
                    #if TST_USE_AES_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - AES            Tests                          "));
                    #endif
                    #endif
                    #ifndef CRYS_NO_DES_SUPPORT
                    #if TST_USE_DES_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - DES/3DES       Tests                          "));
                    #endif
                    #endif
                    #ifndef CRYS_NO_HASH_SUPPORT
                    #if TST_USE_HASH_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [3] - HASH           Tests                          "));
                    #endif
                    #if TST_USE_HMAC_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [4] - HMAC           Tests                          "));
                    #endif
                        #ifndef CRYS_NO_PKI_SUPPORT
                    #if TST_USE_RSA_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [5] - RSA            Tests                          "));
                    #endif
                    #if TST_USE_DH_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [6] - DH             Tests                          "));
                    #endif
                        #endif
                        #ifndef CRYS_NO_ECPKI_SUPPORT
                    #if TST_USE_ECC_DATA
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [7] - ECC            Tests                          "));
                    #endif
                        #endif
                    #if TST_USE_RND_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [8] - RND            Tests                          "));
                    #endif
                    #endif
                    #ifndef CRYS_NO_RC4_SUPPORT
                    #if TST_USE_RC4_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [9] - RC4            Tests                          "));
                    #endif
                    #endif
					#ifndef CRYS_NO_C2_SUPPORT
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [A]-  C2             Tests                          "));
                    #endif
                    
                    #ifndef CRYS_NO_EXT_IF_MODE_SUPPORT
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [B]-  OTF            Tests                          "));
	                #endif
	                    
	                #ifndef CRYS_NO_FLOW_SUPPORT
	                #if TST_USE_FLOW_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [C]-  FLOW   Tests                          "));
	                #endif
                    #endif  
                  
                    #ifndef CRYS_NO_OTF_MC_SUPPORT
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [D]-  OTF Multi Context  Tests                          "));
	                #endif
                    
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------"));
	                
	                
                    #if TST_USE_TEST_DATA
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - Run all Acceptance Tests "));
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n       [with internal KeyGeneration for RSA & ECC]   "));
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------"));
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [S] - Run all Acceptance Tests                      "));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n       [without internal KeyGeneration for RSA & ECC]"));
                    #endif
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests                                  "));
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-------------------------------------------------\n\n"));
	                GET_NON_WHITE_SPACE_CHAR(Var);
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
	                if (Var<='Z')
	                            break;
	                else
	                {
	                        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
	                }

	            }while(1);


	            switch(Var)
	            {

                    case '0':
				            CRYS_ATP_TST_ShowCRYSVersion();
				            break;
                    #ifndef CRYS_NO_AES_SUPPORT
                    #if TST_USE_AES_DATA
		  	        case '1':
				            CRYS_ATP_TST_AES_main();
				            break;
                    #endif
                    #endif
                    #ifndef CRYS_NO_DES_SUPPORT
                    #if TST_USE_DES_DATA
		  	        case '2':
				            CRYS_ATP_TST_DES_main();
				            break;
                    #endif
                    #endif
                    #ifndef CRYS_NO_HASH_SUPPORT
                    #if TST_USE_HASH_DATA
   		  	        case '3':
				            CRYS_ATP_TST_HASH_main();
				            break;
                    #endif
                    #if TST_USE_HMAC_DATA
   		  	        case '4':
				            CRYS_ATP_TST_HMAC_main();
				            break;
                    #endif
                        #ifndef CRYS_NO_PKI_SUPPORT

   		  	        #if TST_USE_RSA_DATA
                    case '5':   
				             CRYS_ATP_TST_RSA_main();
                            break;
                    #endif
                    #if TST_USE_DH_DATA
   		  	        case '6':
				            CRYS_ATP_TST_DH_main();
				            break;
                    #endif
				            #ifndef CRYS_NO_ECPKI_SUPPORT
                    #if TST_USE_ECC_DATA
                    case '7':
                            CRYS_ATP_TST_ECC_main();
                        break;
                    #endif
                            #endif
                        #endif
                    #if TST_USE_RND_DATA
   		  	        case '8':
				            CRYS_ATP_TST_RND_main();
				            break;
                    #endif
                    #endif
                    #ifndef CRYS_NO_RC4_SUPPORT
                    #if TST_USE_RC4_DATA
   		  	        case '9':
				            CRYS_ATP_TST_RC4_main();
				            break;
                    #endif
                    #endif
					#ifndef CRYS_NO_C2_SUPPORT
   		  	        case 'A':
				            CRYS_ATP_TST_C2_main();
				            break;
                    #endif
                    
          #ifndef CRYS_NO_EXT_IF_MODE_SUPPORT
                    #if TST_USE_OTF_DATA
                    case 'B':
	            			CRYS_ATP_TST_OTF_main();
				            break;
                    #endif				            
                    #endif
                    
                    #ifndef CRYS_NO_FLOW_SUPPORT
                    #if TST_USE_FLOW_DATA
                    case 'C':
	            			CRYS_ATP_TST_FLOW_main();
				            break;
                    #endif	
                    #endif	
                    
	               	#ifndef CRYS_NO_OTF_MC_SUPPORT
	                case 'D' :
	                        CRYS_ATP_TST_OTF_MC_main();
				            break;
					#endif				            
				            
					case 'T':
				            CRYS_ATP_TST_RunAllAcceptance_tests(TST_INTERNAL_KG);
				            break;
   		  	        case 'S':
				            CRYS_ATP_TST_RunAllAcceptance_tests(TST_EXTERNAL_KEYPAIR);
				            break;
	       	        case 'Z':
	                        DX_VOS_Printf("\n End of CRYS tests \n");
	                        break ;
	       	        default:
	                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
	            }
	            if(Var =='Z')
	            break;
            }while (1);
        return 0;
    }
    return 0;
 }/* End of CRYS_ATP_TST_menu*/

